import es
import random
import playerlib

import wcs
from wcs import wcs

raceName = 'Night Elf'
race     = wcs.Race(raceName)

""" Load the strings into the variable text """
text     = race.loadStrings()

""" ############################### """
""" ### Begin the configuration ### """
""" ############################### """

config   = race.config()

config.addComment()
config.addComment('********************')
config.addComment('Evasion')
config.addComment('    Players have a chance to ')
config.addComment('    dodge damage from an enemy attack.')
config.addComment('********************')
config.addComment()
evasionMaxLevel      = config.addVar('evasionMaxlevel',       5, 'The maximum level of the Evasion skill') 
evasionLevelInterval = config.addVar('evasionLevelInterval',  2, 'The intervals between the abilities to upgrade their Evasion skill')
evasionPercentage    = config.addVar('evasionPercentage',     5, 'The percentage multiplied by the players level that they will dodge an enemy attack.')

config.addComment()
config.addComment('********************')
config.addComment('Thorns')
config.addComment('    Players have a chance to reflect')
config.addComment('    30% additional damage back to')
config.addComment('    the attacker when hurt.')
config.addComment('********************')
config.addComment()
thornsMaxLevel      = config.addVar('thornsMaxLevel',       4, 'The maximum level of the Thorns skill') 
thornsLevelInterval = config.addVar('thornsLevelInterval',  1, 'The intervals between the abilities to upgrade their Thorns skill')
thornsPercentage    = config.addVar('thornsPercentage',     8, 'The percentage that the thorns will mirror damage upon damage muliplied by the players level.')

config.addComment()
config.addComment('********************')
config.addComment('True Shot')
config.addComment('    Players have a 30% chance to deal')
config.addComment('    additional damage to the victim.')
config.addComment('********************')
config.addComment()
trueMaxLevel      = config.addVar('trueMaxlevel',       4, 'The maximum level of the True Shot skill') 
trueLevelInterval = config.addVar('trueLevelInterval',  1, 'The intervals between the abilities to upgrade their True Shot skill')
truePercentage    = config.addVar('truePercentage',    15, 'The percent of the damage given which is dealt as extra damage.')

config.addComment()
config.addComment('********************')
config.addComment('Entangle')
config.addComment('    This ultimate stops all moving')
config.addComment('    enemies in range. The higher the')
config.addComment('    skill level, the larger the range')
config.addComment('    and the longer they\'re frozen for.')
config.addComment('********************')
config.addComment()
entangleMinLevel      = config.addVar('entangleMinLevel',       7, 'The level required before a player can acquire their skill level in Entangle.')
entangleMaxLevel      = config.addVar('entangleMaxLevel',       3, 'The maximum level of the Entangle skill') 
entangleLevelInterval = config.addVar('entangleLevelInterval',  2, 'The intervals between the abilities to upgrade their Entangle skill')
entangleCoolDown      = config.addVar('entangleCoolDown',       8, 'The amount of seconds after a player uses their Entangle skill until they can use it again.')
entangleDuration      = config.addVar('entangleDuration',       2, 'The amount of time (in seconds) that the \'victims\' in range are frozen for, multiplied via the level.')

config.load(True)

""" ##################### """
""" ### END OF CONFIG ### """
""" ##################### """

race.registerSkill('Evasion',     int(evasionMaxLevel),  int(evasionLevelInterval), 'Have a chance to dodge damage from an attack.')
race.registerSkill('Thorns',      int(thornsMaxLevel),   int(trueLevelInterval),    'Have a chance to reflect 30% damage back at your attacker.')
race.registerSkill('True Shot',   int(trueMaxLevel),     int(trueLevelInterval),    'Have a 30% change to deal bonus damage.')
race.registerUltimate('Entangle', int(entangleMinLevel), int(entangleMaxLevel), int(entangleLevelInterval), 'Use your ultimate to stop all nearby enemies from moving.')

def player_hurt(ev):
    userid   = int(ev['userid'])
    attacker = int(ev['attacker'])
    if attacker:
        damage = int(ev['dmg_health'])
        thorns = wcs.GetLevel(userid, raceName, 'Thorns') * int(thornsPercentage)
        if thorns:
            if random.randint(1,100) <= thorns:
                wcs.Command(attacker).Damage(damage * .3, 32, userid)
                es.tell(userid, '#multi', text('thorns', {'attacker' : ev['es_attackername'], 'damage' : damage * 0.3}, playerlib.getPlayer(userid).get("lang") ) )
                wcs.effect.Beam1(userid, attacker, 1.5, 0, 255, 0)
        trueshot = wcs.GetLevel(attacker, raceName, 'True Shot') * (int(truePercentage) * .01)
        if trueshot:
            if random.randint(1,100) <= 30:
                wcs.Command(userid).Damage(damage * trueshot, 32, attacker)
                es.tell(attacker, '#multi', text('true shot', {'damage' : damage * trueshot}, playerlib.getPlayer(attacker).get("lang") ) )
                wcs.effect.Beam2(attacker, userid, 1.5, 0, 200, 150)

def prep_hurt(ev):
    userid   = int(ev['userid'])
    attacker = int(ev['attacker'])
    if attacker:
        damage  = int(ev['dmg_health'])
        evasion = wcs.GetLevel(userid, raceName, 'Evasion') * int(evasionPercentage)
        if evasion:
            if evasion >= random.randint(1,100):
                wcs.Command(userid).SaveLife(damage)
                es.tell(userid, '#multi', text('evasion', {'damage' : damage}, playerlib.getPlayer(userid).get("lang") ) )
                
def player_ultimate_on(ev):
    userid = int(ev['userid'])
    entangle = wcs.GetLevel(userid, raceName, 'Entangle')
    if entangle:
        filter = '#ct' if ev['es_userteam'] == '2' else '#t'
        wcs.Command(userid).Near(640, stun, filter)
        wcs.Command(userid).SetCoolDown('Entangle', int(entangleCoolDown) )
                
def stun(userid, attacker):
    wcs.Command(userid).Freeze(wcs.GetLevel(attacker, raceName, 'Entangle') * int(entangleDuration) )
    wcs.effect.Beam2(attacker, userid, 1.5, 0, 255, 0)
    es.tell(userid, '#lightgreen', text('entangle', lang = playerlib.getPlayer(userid).get("lang") ) )
